classdef LCD_Lichtwaechter < matlab.System ...
        & coder.ExternalDependency ...
        & matlabshared.sensors.simulink.internal.BlockSampleTime

    % LCD_Lichtwaechter
    %#codegen
    %#ok<*EMCA>

    properties

    end

    properties(Access = protected)
        Logo = 'IO Device Builder';
    end

    properties (Nontunable)

    end

    properties (Access = private)


    end

    methods
        % Constructor
        function obj = LCD_Lichtwaechter(varargin)
            setProperties(obj,nargin,varargin{:});
        end
    end

    methods (Access=protected)
        function setupImpl(obj)
            if ~coder.target('MATLAB')
                coder.cinclude('LCD_Lichtwaechter.h');
                coder.ceval('setupFunctionLCD_Lichtwaechter');
            end
        end

        function validateInputsImpl(obj,varargin)
            %  Check the input size
            if nargin ~=0

                validateattributes(varargin{1},{'logical'},{'2d','size',[1,1]},'','Starte_Spiel');
                validateattributes(varargin{2},{'logical'},{'2d','size',[1,1]},'','Starte_Messung');
                validateattributes(varargin{3},{'logical'},{'2d','size',[1,1]},'','Hilfe');
                validateattributes(varargin{4},{'uint16'},{'2d','size',[1,1]},'','Sensor_Wert');
                validateattributes(varargin{5},{'double'},{'2d','size',[1,1]},'','Zeit_Messung_1');
                validateattributes(varargin{6},{'double'},{'2d','size',[1,1]},'','Zeit_Messung_1_beendet');
                validateattributes(varargin{7},{'double'},{'2d','size',[1,1]},'','Zeit_Messung_2');
                validateattributes(varargin{8},{'double'},{'2d','size',[1,1]},'','Zeit_Messung_2_beendet');
                validateattributes(varargin{9},{'double'},{'2d','size',[1,1]},'','Zeit_Messung_3');
                validateattributes(varargin{10},{'double'},{'2d','size',[1,1]},'','Zeit_Messung_3_beendet');
                validateattributes(varargin{11},{'double'},{'2d','size',[1,1]},'','Zeit_Messung_4');
                validateattributes(varargin{12},{'double'},{'2d','size',[1,1]},'','Zeit_Messung_4_beendet');

            end
        end

        function [Abfrage_1,Abfrage_1_abgeschlossen,Abfrage_2,Abfrage_2_abgeschlossen,Abfrage_3,Abfrage_3_abgeschlossen,Abfrage_4,Abfrage_4_abgeschlossen] = stepImpl(obj ,Starte_Spiel,Starte_Messung,Hilfe,Sensor_Wert,Zeit_Messung_1,Zeit_Messung_1_beendet,Zeit_Messung_2,Zeit_Messung_2_beendet,Zeit_Messung_3,Zeit_Messung_3_beendet,Zeit_Messung_4,Zeit_Messung_4_beendet)
            Abfrage_1 = boolean(zeros(1,1));
            Abfrage_1_abgeschlossen = boolean(zeros(1,1));
            Abfrage_2 = boolean(zeros(1,1));
            Abfrage_2_abgeschlossen = boolean(zeros(1,1));
            Abfrage_3 = boolean(zeros(1,1));
            Abfrage_3_abgeschlossen = boolean(zeros(1,1));
            Abfrage_4 = boolean(zeros(1,1));
            Abfrage_4_abgeschlossen = boolean(zeros(1,1));
            if isempty(coder.target)
            else
                coder.ceval('stepFunctionLCD_Lichtwaechter',coder.ref(Abfrage_1),1,coder.ref(Abfrage_1_abgeschlossen),1,coder.ref(Abfrage_2),1,coder.ref(Abfrage_2_abgeschlossen),1,coder.ref(Abfrage_3),1,coder.ref(Abfrage_3_abgeschlossen),1,coder.ref(Abfrage_4),1,coder.ref(Abfrage_4_abgeschlossen),1, Starte_Spiel,1, Starte_Messung,1, Hilfe,1, Sensor_Wert,1, Zeit_Messung_1,1, Zeit_Messung_1_beendet,1, Zeit_Messung_2,1, Zeit_Messung_2_beendet,1, Zeit_Messung_3,1, Zeit_Messung_3_beendet,1, Zeit_Messung_4,1, Zeit_Messung_4_beendet,1);
            end
        end

        function releaseImpl(obj)
            if isempty(coder.target)
            else

            end
        end
    end

    methods (Access=protected)
        %% Define output properties
        function num = getNumInputsImpl(~)
            num = 12;
        end

        function num = getNumOutputsImpl(~)
            num = 8;
        end

        function varargout = getInputNamesImpl(obj)
            varargout{1} = 'Starte_Spiel';
            varargout{2} = 'Starte_Messung';
            varargout{3} = 'Hilfe';
            varargout{4} = 'Sensor_Wert';
            varargout{5} = 'Zeit_Messung_1';
            varargout{6} = 'Zeit_Messung_1_beendet';
            varargout{7} = 'Zeit_Messung_2';
            varargout{8} = 'Zeit_Messung_2_beendet';
            varargout{9} = 'Zeit_Messung_3';
            varargout{10} = 'Zeit_Messung_3_beendet';
            varargout{11} = 'Zeit_Messung_4';
            varargout{12} = 'Zeit_Messung_4_beendet';

        end

        function varargout = getOutputNamesImpl(obj)
            varargout{1} = 'Abfrage_1';
            varargout{2} = 'Abfrage_1_abgeschlossen';
            varargout{3} = 'Abfrage_2';
            varargout{4} = 'Abfrage_2_abgeschlossen';
            varargout{5} = 'Abfrage_3';
            varargout{6} = 'Abfrage_3_abgeschlossen';
            varargout{7} = 'Abfrage_4';
            varargout{8} = 'Abfrage_4_abgeschlossen';
        end

        function flag = isOutputSizeLockedImpl(~,~)
            flag = true;
        end

        function varargout = isOutputFixedSizeImpl(~,~)
            varargout{1} = true;
            varargout{2} = true;
            varargout{3} = true;
            varargout{4} = true;
            varargout{5} = true;
            varargout{6} = true;
            varargout{7} = true;
            varargout{8} = true;
        end

        function varargout = isOutputComplexImpl(~)
            varargout{1} = false;
            varargout{2} = false;
            varargout{3} = false;
            varargout{4} = false;
            varargout{5} = false;
            varargout{6} = false;
            varargout{7} = false;
            varargout{8} = false;
        end

        function varargout = getOutputSizeImpl(~)
            varargout{1} = [1,1];
            varargout{2} = [1,1];
            varargout{3} = [1,1];
            varargout{4} = [1,1];
            varargout{5} = [1,1];
            varargout{6} = [1,1];
            varargout{7} = [1,1];
            varargout{8} = [1,1];
        end

        function varargout = getOutputDataTypeImpl(~)
            varargout{1} = 'boolean';
            varargout{2} = 'boolean';
            varargout{3} = 'boolean';
            varargout{4} = 'boolean';
            varargout{5} = 'boolean';
            varargout{6} = 'boolean';
            varargout{7} = 'boolean';
            varargout{8} = 'boolean';
        end

        function maskDisplayCmds = getMaskDisplayImpl(obj)
            outport_label = [];
            num = getNumOutputsImpl(obj);
            if num > 0
                outputs = cell(1,num);
                [outputs{1:num}] = getOutputNamesImpl(obj);
                for i = 1:num
                    outport_label = [outport_label 'port_label(''output'',' num2str(i) ',''' outputs{i} ''');' ]; %#ok<AGROW>
                end
            end
            inport_label = [];
            num = getNumInputsImpl(obj);
            if num > 0
                inputs = cell(1,num);
                [inputs{1:num}] = getInputNamesImpl(obj);
                for i = 1:num
                    inport_label = [inport_label 'port_label(''input'',' num2str(i) ',''' inputs{i} ''');' ]; %#ok<AGROW>
                end
            end
            icon = 'LCD_Lichtwaechter';
            maskDisplayCmds = [ ...
                ['color(''white'');',...
                'plot([100,100,100,100]*1,[100,100,100,100]*1);',...
                'plot([100,100,100,100]*0,[100,100,100,100]*0);',...
                'color(''blue'');', ...
                ['text(38, 92, ','''',obj.Logo,'''',',''horizontalAlignment'', ''right'');',newline],...
                'color(''black'');'], ...
                ['text(52,50,' [''' ' icon ''',''horizontalAlignment'',''center'');' newline]]   ...
                inport_label ...
                outport_label
                ];
        end

        function sts = getSampleTimeImpl(obj)
            sts = getSampleTimeImpl@matlabshared.sensors.simulink.internal.BlockSampleTime(obj);
        end
    end

    methods (Static, Access=protected)
        function simMode = getSimulateUsingImpl(~)
            simMode = 'Interpreted execution';
        end

        function isVisible = showSimulateUsingImpl
            isVisible = false;
        end
    end

    methods (Static)
        function name = getDescriptiveName()
            name = 'LCD_Lichtwaechter';
        end

        function b = isSupportedContext(context)
            b = context.isCodeGenTarget('rtw');
        end

        function updateBuildInfo(buildInfo, context)
            coder.extrinsic('codertarget.targethardware.getTargetHardware');
            hCS = coder.const(getActiveConfigSet(bdroot));
            targetInfo = coder.const(codertarget.targethardware.getTargetHardware(hCS));

            % Added this env variable to fetch the comm libraries required only for Arduino target.
            % The env variable is cleared at the end of
            % "GenerateWrapperMakefile.m" file.
            if contains(targetInfo.TargetName,'arduinotarget')
                setenv('Arduino_ML_Codegen_I2C', 'Y');
            end

            buildInfo.addIncludePaths('C:\Users\andre\Desktop\Arbeitsordner\libs');

            buildInfo.addIncludePaths('C:\Users\andre\Desktop\Arbeitsordner');
            addSourceFiles(buildInfo,'LiquidCrystal_I2C.cpp','C:\Users\andre\Desktop\Arbeitsordner\libs');
            addSourceFiles(buildInfo,'LCD_Lichtwaechter.cpp','C:\Users\andre\Desktop\Arbeitsordner');

        end
    end
end
